clear all;close all;clc %#ok<CLALL> 
load Alldata

% B = Brake-lights condition
% O = Occlusion condition
% V = No-brake-lights condition

% a1d1 = 1.7 m/s^2, 13.4 m
% a2d1 = 6.5 m/s^2, 13.4 m
% a1d2 = 1.7 m/s^2, 33.4 m
% a2d2 = 6.5 m/s^2, 33.4 m

% Ind_D = distance to lead vehicle (feet) (bumber-to-bumper, note that the vehicle length is 4.84 m)
% Ind_A = vehicle acceleration (feet/s)
% Ind_F = brake position (%)
% Ind_Vl = lead-vehicle speed (feet/s)
% Ind_V = ego-vehicle speed (mph)
% Int_Thr = throttle position (0 to 1)

Bb(1,:,:)=B.Ind_F_a1d1(:,:,1); % initial brake position
Bb(2,:,:)=B.Ind_F_a2d1(:,:,1);
Bb(3,:,:)=B.Ind_F_a1d2(:,:,1);
Bb(4,:,:)=B.Ind_F_a2d2(:,:,1);

Vb(1,:,:)=V.Ind_F_a1d1(:,:,1);
Vb(2,:,:)=V.Ind_F_a2d1(:,:,1);
Vb(3,:,:)=V.Ind_F_a1d2(:,:,1);
Vb(4,:,:)=V.Ind_F_a2d2(:,:,1);

Ob(1,:,:)=O.Ind_F_a1d1(:,:,1);
Ob(2,:,:)=O.Ind_F_a2d1(:,:,1);
Ob(3,:,:)=O.Ind_F_a1d2(:,:,1);
Ob(4,:,:)=O.Ind_F_a2d2(:,:,1);

Bd(1,:,:)=B.Ind_D_a1d1(:,:,2); % initial following distance
Bd(2,:,:)=B.Ind_D_a2d1(:,:,2);
Bd(3,:,:)=B.Ind_D_a1d2(:,:,2);
Bd(4,:,:)=B.Ind_D_a2d2(:,:,2);

Vd(1,:,:)=V.Ind_D_a1d1(:,:,2);
Vd(2,:,:)=V.Ind_D_a2d1(:,:,2);
Vd(3,:,:)=V.Ind_D_a1d2(:,:,2);
Vd(4,:,:)=V.Ind_D_a2d2(:,:,2);

Od(1,:,:)=O.Ind_D_a1d1(:,:,2);
Od(2,:,:)=O.Ind_D_a2d1(:,:,2);
Od(3,:,:)=O.Ind_D_a1d2(:,:,2);
Od(4,:,:)=O.Ind_D_a2d2(:,:,2);

DM=nanmedian([nanmedian(squeeze(nanmedian(Bd*0.3048,2)),2) nanmedian(squeeze(nanmedian(Vd*0.3048,2)),2) nanmedian(squeeze(nanmedian(Od*0.3048,2)),2)],2); %#ok<*NANMEDIAN> 
DMl=nanmedian(DM(1:2));
DMh=nanmedian(DM(3:4));
TD=repmat([DMl;DMl;DMh;DMh],1,12,4); % 4 x 12 x 4 matrix of target starting distances

BF=double(Bb>0)+double(abs(Bd*0.3048-TD)>.5); % filter when braking at the start OR when deviating more than 0.5 m from the expected initial distance
VF=double(Vb>0)+double(abs(Vd*0.3048-TD)>.5);
OF=double(Ob>0)+double(abs(Od*0.3048-TD)>.5);

disp('Number of excluded trials in the Brake-lights, No-brake-lights and Occlusion condition')
disp([sum(sum(sum(BF))) sum(sum(sum(VF))) sum(sum(sum(OF)))]); % number of excluded trials
disp('Number of included trials in the Brake-lights, No-brake-lights and Occlusion condition')
disp([sum(sum(sum(BF==0))) sum(sum(sum(VF==0))) sum(sum(sum(OF==0)))]); % number of included trials

for i=1:12 % loop across number of participants
    for i2=1:4 % loop across number of trials
        [~,B.tRT(1,i,i2)]=find(B.Ind_F_a1d1(i,i2,1:1081)>0,1,'first');
        [~,B.tRT(2,i,i2)]=find(B.Ind_F_a2d1(i,i2,1:721)>0,1,'first');
        [~,B.tRT(3,i,i2)]=find(B.Ind_F_a1d2(i,i2,1:1081)>0,1,'first');
        [~,B.tRT(4,i,i2)]=find(B.Ind_F_a2d2(i,i2,1:721)>0,1,'first');

        B.Dmin(1,i,i2)=0.3048*min(B.Ind_D_a1d1(i,i2,2:2:1081));
        B.Dmin(2,i,i2)=0.3048*min(B.Ind_D_a2d1(i,i2,2:2:721));
        B.Dmin(3,i,i2)=0.3048*min(B.Ind_D_a1d2(i,i2,2:2:1081));
        B.Dmin(4,i,i2)=0.3048*min(B.Ind_D_a2d2(i,i2,2:2:721));
        
        if BF(1,i,i2)==1
            B.Ind_D_a1d1(i,i2,:)=NaN;
            B.Ind_D_a1d1(i,i2,:)=NaN;
            B.Ind_V_a1d1(i,i2,:)=NaN; % Speed
            B.Ind_A_a1d1(i,i2,:)=NaN;
            B.Ind_F_a1d1(i,i2,:)=NaN; % Brake position
            B.Ind_Vl_a1d1(i,i2,:)=NaN;
            B.Ind_Thr_a1d1(i,i2,:)=NaN; % Throttle
        end
        if BF(2,i,i2)==1
            B.Ind_D_a2d1(i,i2,:)=NaN;
            B.Ind_D_a2d1(i,i2,:)=NaN;
            B.Ind_V_a2d1(i,i2,:)=NaN;
            B.Ind_A_a2d1(i,i2,:)=NaN;
            B.Ind_F_a2d1(i,i2,:)=NaN;
            B.Ind_Vl_a2d1(i,i2,:)=NaN;
            B.Ind_Thr_a2d1(i,i2,:)=NaN;
        end
        if BF(3,i,i2)==1
            B.Ind_D_a1d2(i,i2,:)=NaN;
            B.Ind_D_a1d2(i,i2,:)=NaN;
            B.Ind_V_a1d2(i,i2,:)=NaN;
            B.Ind_A_a1d2(i,i2,:)=NaN;
            B.Ind_F_a1d2(i,i2,:)=NaN;
            B.Ind_Vl_a1d2(i,i2,:)=NaN;
            B.Ind_Thr_a1d2(i,i2,:)=NaN;
        end
        if BF(4,i,i2)==1
            B.Ind_D_a2d2(i,i2,:)=NaN;
            B.Ind_D_a2d2(i,i2,:)=NaN;
            B.Ind_V_a2d2(i,i2,:)=NaN;
            B.Ind_A_a2d2(i,i2,:)=NaN;
            B.Ind_F_a2d2(i,i2,:)=NaN;
            B.Ind_Vl_a2d2(i,i2,:)=NaN;
            B.Ind_Thr_a2d2(i,i2,:)=NaN;
        end
    end
end
for i=1:12 % loop across number of participants
    for i2=1:4 % loop across number of trials
   
        [~,V.tRT(1,i,i2)]=find(V.Ind_F_a1d1(i,i2,1:1081)>0,1,'first'); 
        [~,V.tRT(2,i,i2)]=find(V.Ind_F_a2d1(i,i2,1:721)>0,1,'first');
        [~,V.tRT(3,i,i2)]=find(V.Ind_F_a1d2(i,i2,1:1081)>0,1,'first');
        [~,V.tRT(4,i,i2)]=find(V.Ind_F_a2d2(i,i2,1:721)>0,1,'first');
        
        V.Dmin(1,i,i2)=0.3048*min(V.Ind_D_a1d1(i,i2,2:2:1081));
        V.Dmin(2,i,i2)=0.3048*min(V.Ind_D_a2d1(i,i2,2:2:721));
        V.Dmin(3,i,i2)=0.3048*min(V.Ind_D_a1d2(i,i2,2:2:1081));
        V.Dmin(4,i,i2)=0.3048*min(V.Ind_D_a2d2(i,i2,2:2:721));
        
        if VF(1,i,i2)==1
            V.Ind_D_a1d1(i,i2,:)=NaN;
            V.Ind_D_a1d1(i,i2,:)=NaN;
            V.Ind_V_a1d1(i,i2,:)=NaN;
            V.Ind_A_a1d1(i,i2,:)=NaN;
            V.Ind_F_a1d1(i,i2,:)=NaN;
            V.Ind_Vl_a1d1(i,i2,:)=NaN;
            V.Ind_Thr_a1d1(i,i2,:)=NaN;
        end
        if VF(2,i,i2)==1
            V.Ind_D_a2d1(i,i2,:)=NaN;
            V.Ind_D_a2d1(i,i2,:)=NaN;
            V.Ind_V_a2d1(i,i2,:)=NaN;
            V.Ind_A_a2d1(i,i2,:)=NaN;
            V.Ind_F_a2d1(i,i2,:)=NaN;
            V.Ind_Vl_a2d1(i,i2,:)=NaN;
            V.Ind_Thr_a2d1(i,i2,:)=NaN;
        end
        if VF(3,i,i2)==1
            V.Ind_D_a1d2(i,i2,:)=NaN;
            V.Ind_D_a1d2(i,i2,:)=NaN;
            V.Ind_V_a1d2(i,i2,:)=NaN;
            V.Ind_A_a1d2(i,i2,:)=NaN;
            V.Ind_F_a1d2(i,i2,:)=NaN;
            V.Ind_Vl_a1d2(i,i2,:)=NaN;
            V.Ind_Thr_a1d2(i,i2,:)=NaN;
        end
        if VF(4,i,i2)==1
            V.Ind_D_a2d2(i,i2,:)=NaN;
            V.Ind_D_a2d2(i,i2,:)=NaN;
            V.Ind_V_a2d2(i,i2,:)=NaN;
            V.Ind_A_a2d2(i,i2,:)=NaN;
            V.Ind_F_a2d2(i,i2,:)=NaN;
            V.Ind_Vl_a2d2(i,i2,:)=NaN;
            V.Ind_Thr_a2d2(i,i2,:)=NaN;
        end
    end
end
for i=1:12 % loop across number of participants
    for i2=1:4 % loop across number of trials
        [~,O.tRT(1,i,i2)]=find(O.Ind_F_a1d1(i,i2,1:1081)>0,1,'first');
        [~,O.tRT(2,i,i2)]=find(O.Ind_F_a2d1(i,i2,1:721)>0,1,'first');
        [~,O.tRT(3,i,i2)]=find(O.Ind_F_a1d2(i,i2,1:1081)>0,1,'first');
        [~,O.tRT(4,i,i2)]=find(O.Ind_F_a2d2(i,i2,1:721)>0,1,'first');

        O.Dmin(1,i,i2)=0.3048*min(O.Ind_D_a1d1(i,i2,2:2:1081));
        O.Dmin(2,i,i2)=0.3048*min(O.Ind_D_a2d1(i,i2,2:2:721));
        O.Dmin(3,i,i2)=0.3048*min(O.Ind_D_a1d2(i,i2,2:2:1081));
        O.Dmin(4,i,i2)=0.3048*min(O.Ind_D_a2d2(i,i2,2:2:721));
        if OF(1,i,i2)==1
            O.Ind_D_a1d1(i,i2,:)=NaN;
            O.Ind_D_a1d1(i,i2,:)=NaN;
            O.Ind_V_a1d1(i,i2,:)=NaN;
            O.Ind_A_a1d1(i,i2,:)=NaN;
            O.Ind_F_a1d1(i,i2,:)=NaN;
            O.Ind_Vl_a1d1(i,i2,:)=NaN;
            O.Ind_Thr_a1d1(i,i2,:)=NaN;
        end
        if OF(2,i,i2)==1
            O.Ind_D_a2d1(i,i2,:)=NaN;
            O.Ind_D_a2d1(i,i2,:)=NaN;
            O.Ind_V_a2d1(i,i2,:)=NaN;
            O.Ind_A_a2d1(i,i2,:)=NaN;
            O.Ind_F_a2d1(i,i2,:)=NaN;
            O.Ind_Vl_a2d1(i,i2,:)=NaN;
            O.Ind_Thr_a2d1(i,i2,:)=NaN;
        end
        if OF(3,i,i2)==1
            O.Ind_D_a1d2(i,i2,:)=NaN;
            O.Ind_D_a1d2(i,i2,:)=NaN;
            O.Ind_V_a1d2(i,i2,:)=NaN;
            O.Ind_A_a1d2(i,i2,:)=NaN;
            O.Ind_F_a1d2(i,i2,:)=NaN;
            O.Ind_Vl_a1d2(i,i2,:)=NaN;
            O.Ind_Thr_a1d2(i,i2,:)=NaN;
        end
        if OF(4,i,i2)==1
            O.Ind_D_a2d2(i,i2,:)=NaN;
            O.Ind_D_a2d2(i,i2,:)=NaN;
            O.Ind_V_a2d2(i,i2,:)=NaN;
            O.Ind_A_a2d2(i,i2,:)=NaN;
            O.Ind_F_a2d2(i,i2,:)=NaN;
            O.Ind_Vl_a2d2(i,i2,:)=NaN;
            O.Ind_Thr_a2d2(i,i2,:)=NaN;
        end
    end
end

B.Sum_D_a1d1=0.3048*squeeze(mean(nanmean(B.Ind_D_a1d1))); %#ok<*NANMEAN> 
B.Sum_D_a2d1=0.3048*squeeze(mean(nanmean(B.Ind_D_a2d1)));
B.Sum_D_a1d2=0.3048*squeeze(mean(nanmean(B.Ind_D_a1d2)));
B.Sum_D_a2d2=0.3048*squeeze(mean(nanmean(B.Ind_D_a2d2)));
V.Sum_D_a1d1=0.3048*squeeze(mean(nanmean(V.Ind_D_a1d1)));
V.Sum_D_a2d1=0.3048*squeeze(mean(nanmean(V.Ind_D_a2d1)));
V.Sum_D_a1d2=0.3048*squeeze(mean(nanmean(V.Ind_D_a1d2)));
V.Sum_D_a2d2=0.3048*squeeze(mean(nanmean(V.Ind_D_a2d2)));
O.Sum_D_a1d1=0.3048*squeeze(mean(nanmean(O.Ind_D_a1d1)));
O.Sum_D_a2d1=0.3048*squeeze(mean(nanmean(O.Ind_D_a2d1)));
O.Sum_D_a1d2=0.3048*squeeze(mean(nanmean(O.Ind_D_a1d2)));
O.Sum_D_a2d2=0.3048*squeeze(mean(nanmean(O.Ind_D_a2d2)));

B.Sum_F_a1d1=squeeze(mean(nanmean(B.Ind_F_a1d1)));
B.Sum_F_a2d1=squeeze(mean(nanmean(B.Ind_F_a2d1)));
B.Sum_F_a1d2=squeeze(mean(nanmean(B.Ind_F_a1d2)));
B.Sum_F_a2d2=squeeze(mean(nanmean(B.Ind_F_a2d2)));
V.Sum_F_a1d1=squeeze(mean(nanmean(V.Ind_F_a1d1)));
V.Sum_F_a2d1=squeeze(mean(nanmean(V.Ind_F_a2d1)));
V.Sum_F_a1d2=squeeze(mean(nanmean(V.Ind_F_a1d2)));
V.Sum_F_a2d2=squeeze(mean(nanmean(V.Ind_F_a2d2)));
O.Sum_F_a1d1=squeeze(mean(nanmean(O.Ind_F_a1d1)));
O.Sum_F_a2d1=squeeze(mean(nanmean(O.Ind_F_a2d1)));
O.Sum_F_a1d2=squeeze(mean(nanmean(O.Ind_F_a1d2)));
O.Sum_F_a2d2=squeeze(mean(nanmean(O.Ind_F_a2d2)));

B.tRT(find(BF))=NaN;
B.Dmin(find(BF))=NaN;
Bd(BF==1)=NaN;

V.tRT(find(VF))=NaN;
V.Dmin(find(VF))=NaN;
Vd(VF==1)=NaN;

O.tRT(find(OF))=NaN;
O.Dmin(find(OF))=NaN;
Od(OF==1)=NaN;

%% Figure 3. Brake pedal position in the 13.4 m, 1.7 m/s2 condition, for each of the recorded trials. In the occlusion condition, drivers were asked to brake after the 2-s-long occlusion had cleared.
% a1d1 = 1.7 m/s^2, 13.4 m
% a2d1 = 6.5 m/s^2, 13.4 m
% a1d2 = 1.7 m/s^2, 33.4 m
% a2d2 = 6.5 m/s^2, 33.4 m
figure;hold on
counter=0;
for i=1:12
    for i2=1:4
        counter=counter+1;
        subplot(3,1,1)
        title('Brake lights')
        plot((1:2:1080)/60,squeeze(B.Ind_F_a1d1(i,i2,2:2:1081)),'k','linewidth',3);hold on
        grid on
        set(gca,'xlim',[0 6])
        if counter==48
            title('Brake lights')
            set(gca,'xlim',[0 6],'pos',[0.07 0.755 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
        end
        
        subplot(3,1,2)
        title('No brake lights')
        plot((1:2:1080)/60,squeeze(V.Ind_F_a1d1(i,i2,2:2:1081)),'r','linewidth',3);hold on
        if counter==48
            set(gca,'xlim',[0 6],'pos',[0.07 0.435 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
        
        subplot(3,1,3)
        plot((1:2:1080)/60,squeeze(O.Ind_F_a1d1(i,i2,2:2:1081)),'b','linewidth',3);hold on
        if counter==48
            title('Occlusion')
            set(gca,'xlim',[0 6],'pos',[0.07 0.115 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
    end
end

xlabel('Time (s)')
ylabel('Brake (%)')
h=findobj('FontName','Helvetica'); set(h,'FontSize',24,'Fontname','Arial')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01])
set(gcf,'pos',[680 197 847 781])
%%
O.Ind_Vl_a2d1(O.Ind_Vl_a2d1==0)=NaN; % remove a few samples where lead vehicle data is unavailable (data logger interruption for participants 2, 9, 12)
B.Sum_Vl_a1d1=squeeze(mean(nanmean(B.Ind_Vl_a1d1)))*0.3048*3.6;
B.Sum_Vl_a2d1=squeeze(mean(nanmean(B.Ind_Vl_a2d1)))*0.3048*3.6;
B.Sum_Vl_a1d2=squeeze(mean(nanmean(B.Ind_Vl_a1d2)))*0.3048*3.6;
B.Sum_Vl_a2d2=squeeze(mean(nanmean(B.Ind_Vl_a2d2)))*0.3048*3.6;
V.Sum_Vl_a1d1=squeeze(mean(nanmean(V.Ind_Vl_a1d1)))*0.3048*3.6;
V.Sum_Vl_a2d1=squeeze(mean(nanmean(V.Ind_Vl_a2d1)))*0.3048*3.6;
V.Sum_Vl_a1d2=squeeze(mean(nanmean(V.Ind_Vl_a1d2)))*0.3048*3.6;
V.Sum_Vl_a2d2=squeeze(mean(nanmean(V.Ind_Vl_a2d2)))*0.3048*3.6;
O.Sum_Vl_a1d1=squeeze(mean(nanmean(O.Ind_Vl_a1d1)))*0.3048*3.6;
O.Sum_Vl_a2d1=squeeze(mean(nanmean(O.Ind_Vl_a2d1)))*0.3048*3.6;
O.Sum_Vl_a1d2=squeeze(mean(nanmean(O.Ind_Vl_a1d2)))*0.3048*3.6;
O.Sum_Vl_a2d2=squeeze(mean(nanmean(O.Ind_Vl_a2d2)))*0.3048*3.6;

B.Sum_V_a1d1=squeeze(mean(nanmean(B.Ind_V_a1d1)))*1.60934; % speed in kph (convert from mph)
B.Sum_V_a2d1=squeeze(mean(nanmean(B.Ind_V_a2d1)))*1.60934;
B.Sum_V_a1d2=squeeze(mean(nanmean(B.Ind_V_a1d2)))*1.60934;
B.Sum_V_a2d2=squeeze(mean(nanmean(B.Ind_V_a2d2)))*1.60934;
V.Sum_V_a1d1=squeeze(mean(nanmean(V.Ind_V_a1d1)))*1.60934;
V.Sum_V_a2d1=squeeze(mean(nanmean(V.Ind_V_a2d1)))*1.60934;
V.Sum_V_a1d2=squeeze(mean(nanmean(V.Ind_V_a1d2)))*1.60934;
V.Sum_V_a2d2=squeeze(mean(nanmean(V.Ind_V_a2d2)))*1.60934;
O.Sum_V_a1d1=squeeze(mean(nanmean(O.Ind_V_a1d1)))*1.60934;
O.Sum_V_a2d1=squeeze(mean(nanmean(O.Ind_V_a2d1)))*1.60934;
O.Sum_V_a1d2=squeeze(mean(nanmean(O.Ind_V_a1d2)))*1.60934;
O.Sum_V_a2d2=squeeze(mean(nanmean(O.Ind_V_a2d2)))*1.60934;

B.Sum_A_a1d1=squeeze(mean(nanmean(B.Ind_A_a1d1)))*-0.3048; % deceleration in m/s^2
B.Sum_A_a2d1=squeeze(mean(nanmean(B.Ind_A_a2d1)))*-0.3048;
B.Sum_A_a1d2=squeeze(mean(nanmean(B.Ind_A_a1d2)))*-0.3048;
B.Sum_A_a2d2=squeeze(mean(nanmean(B.Ind_A_a2d2)))*-0.3048;
V.Sum_A_a1d1=squeeze(mean(nanmean(V.Ind_A_a1d1)))*-0.3048;
V.Sum_A_a2d1=squeeze(mean(nanmean(V.Ind_A_a2d1)))*-0.3048;
V.Sum_A_a1d2=squeeze(mean(nanmean(V.Ind_A_a1d2)))*-0.3048;
V.Sum_A_a2d2=squeeze(mean(nanmean(V.Ind_A_a2d2)))*-0.3048;
O.Sum_A_a1d1=squeeze(mean(nanmean(O.Ind_A_a1d1)))*-0.3048;
O.Sum_A_a2d1=squeeze(mean(nanmean(O.Ind_A_a2d1)))*-0.3048;
O.Sum_A_a1d2=squeeze(mean(nanmean(O.Ind_A_a1d2)))*-0.3048;
O.Sum_A_a2d2=squeeze(mean(nanmean(O.Ind_A_a2d2)))*-0.3048;

B.Sum_Thr_a1d1=100*squeeze(mean(nanmean(B.Ind_Thr_a1d1)));
B.Sum_Thr_a2d1=100*squeeze(mean(nanmean(B.Ind_Thr_a2d1)));
B.Sum_Thr_a1d2=100*squeeze(mean(nanmean(B.Ind_Thr_a1d2)));
B.Sum_Thr_a2d2=100*squeeze(mean(nanmean(B.Ind_Thr_a2d2)));
V.Sum_Thr_a1d1=100*squeeze(mean(nanmean(V.Ind_Thr_a1d1)));
V.Sum_Thr_a2d1=100*squeeze(mean(nanmean(V.Ind_Thr_a2d1)));
V.Sum_Thr_a1d2=100*squeeze(mean(nanmean(V.Ind_Thr_a1d2)));
V.Sum_Thr_a2d2=100*squeeze(mean(nanmean(V.Ind_Thr_a2d2)));
O.Sum_Thr_a1d1=100*squeeze(mean(nanmean(O.Ind_Thr_a1d1)));
O.Sum_Thr_a2d1=100*squeeze(mean(nanmean(O.Ind_Thr_a2d1)));
O.Sum_Thr_a1d2=100*squeeze(mean(nanmean(O.Ind_Thr_a1d2)));
O.Sum_Thr_a2d2=100*squeeze(mean(nanmean(O.Ind_Thr_a2d2)));

%% Figure S1. The mean throttle pedal position in the different braking conditions. Note that in the occlusion condition, the simulator screens blanked for 0.4 s (if 6.5 m/s2) or 2.0 s (if 1.7 m/s2).
figure
subplot(2,2,1);hold on
plot((0:1:1080)/60,B.Sum_Thr_a1d1(1:1081),'color',[0 0 0],'LineWidth',3);
plot((0:1:1080)/60,V.Sum_Thr_a1d1(1:1081),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:1080)/60,O.Sum_Thr_a1d1(1:1081),':','color',[0 0 1],'LineWidth',3);
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[0 80])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Throttle position (%)','Fontsize',20)
text(1,70,'1.7 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,2);hold on
plot((0:1:720)/60,B.Sum_Thr_a2d1(1:721),'color',[0 0 0],'LineWidth',3);
plot((0:1:720)/60,V.Sum_Thr_a2d1(1:721),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:720)/60,O.Sum_Thr_a2d1(1:721),':','color',[0 0 1],'LineWidth',3);
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[0 80])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Throttle position (%)','Fontsize',20)
text(1*12/18,70,'6.5 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,3);hold on
plot((0:1:1080)/60,B.Sum_Thr_a1d2(1:1081),'color',[0 0 0],'LineWidth',3);
plot((0:1:1080)/60,V.Sum_Thr_a1d2(1:1081),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:1080)/60,O.Sum_Thr_a1d2(1:1081),':','color',[0 0 1],'LineWidth',3);
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[0 80])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Throttle position (%)','Fontsize',20)
text(1,70,'1.7 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,4);hold on
plot((0:1:720)/60,B.Sum_Thr_a2d2(1:721),'color',[0 0 0],'LineWidth',3);
plot((0:1:720)/60,V.Sum_Thr_a2d2(1:721),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:720)/60,O.Sum_Thr_a2d2(1:721),':','color',[0 0 1],'LineWidth',3);
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Throttle position (%)','Fontsize',20)
text(1*12/18,70,'6.5 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[0 80])
h=findobj('FontName','Helvetica');
set(h,'FontSize',20,'Fontname','Arial')
h=legend('Brake lights','No brake lights','Occlusion');
set(h,'position',[0.273188818560372 0.948945404150761 0.452951397245959 0.0438689226327937],'Orientation','horizontal');
box on
%% Figure S2. The mean brake pedal position in the different braking conditions. Note that in the occlusion condition, the simulator screens blanked for 0.4 s (if 6.5 m/s2) or 2.0 s (if 1.7 m/s2).
figure
subplot(2,2,1);hold on
plot((0:1:1080)/60,B.Sum_F_a1d1(1:1081),'color',[0 0 0],'LineWidth',3);
plot((0:1:1080)/60,V.Sum_F_a1d1(1:1081),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:1080)/60,O.Sum_F_a1d1(1:1081),':','color',[0 0 1],'LineWidth',3);
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[0 100])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Brake position (%)','Fontsize',20)
text(10,90,'1.7 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,2);hold on
plot((0:1:720)/60,B.Sum_F_a2d1(1:721),'color',[0 0 0],'LineWidth',3);
plot((0:1:720)/60,V.Sum_F_a2d1(1:721),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:720)/60,O.Sum_F_a2d1(1:721),':','color',[0 0 1],'LineWidth',3);
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[0 100])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Brake position (%)','Fontsize',20)
text(10*12/18,90,'6.5 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,3);hold on
plot((0:1:1080)/60,B.Sum_F_a1d2(1:1081),'color',[0 0 0],'LineWidth',3);
plot((0:1:1080)/60,V.Sum_F_a1d2(1:1081),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:1080)/60,O.Sum_F_a1d2(1:1081),':','color',[0 0 1],'LineWidth',3);
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[0 100])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Brake position (%)','Fontsize',20)
text(10,90,'1.7 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,4);hold on
plot((0:1:720)/60,B.Sum_F_a2d2(1:721),'color',[0 0 0],'LineWidth',3);
plot((0:1:720)/60,V.Sum_F_a2d2(1:721),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:720)/60,O.Sum_F_a2d2(1:721),':','color',[0 0 1],'LineWidth',3);
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Brake position (%)','Fontsize',20)
text(10*12/18,90,'6.5 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[0 100])
h=findobj('FontName','Helvetica');
set(h,'FontSize',20,'Fontname','Arial')
h=legend('Brake lights','No brake lights','Occlusion');
set(h,'position',[0.273188818560372 0.948945404150761 0.452951397245959 0.0438689226327937],'Orientation','horizontal');
box on
%% Figure S3. The vehicle deceleration in the different braking conditions. Note that in the occlusion condition, the simulator screens blanked for 0.4 s (if 6.5 m/s2) or 2.0 s (if 1.7 m/s2).
figure
subplot(2,2,1);hold on
plot((1:2:1080)/60,B.Sum_A_a1d1(2:2:1081),'color',[0 0 0],'LineWidth',3);
plot((1:2:1080)/60,V.Sum_A_a1d1(2:2:1081),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:1080)/60,O.Sum_A_a1d1(2:2:1081),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[-3 10])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Deceleration (m/s^2)','Fontsize',20)
text(10,8,'1.7 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,2);hold on
plot((1:2:720)/60,B.Sum_A_a2d1(2:2:721),'color',[0 0 0],'LineWidth',3);
plot((1:2:720)/60,V.Sum_A_a2d1(2:2:721),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:720)/60,O.Sum_A_a2d1(2:2:721),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[-3 10])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Deceleration (m/s^2)','Fontsize',20)
text(10*12/18,8,'6.5 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,3);hold on
plot((1:2:1080)/60,B.Sum_A_a1d2(2:2:1081),'color',[0 0 0],'LineWidth',3);
plot((1:2:1080)/60,V.Sum_A_a1d2(2:2:1081),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:1080)/60,O.Sum_A_a1d2(2:2:1081),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[-3 10])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Deceleration (m/s^2)','Fontsize',20)
text(10,8,'1.7 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,4);hold on
plot((1:2:720)/60,B.Sum_A_a2d2(2:2:721),'color',[0 0 0],'LineWidth',3);
plot((1:2:720)/60,V.Sum_A_a2d2(2:2:721),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:720)/60,O.Sum_A_a2d2(2:2:721),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Deceleration (m/s^2)','Fontsize',20)
text(10*12/18,8,'6.5 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[-3 10])
h=findobj('FontName','Helvetica');
set(h,'FontSize',20,'Fontname','Arial')
h=legend('Brake lights','No brake lights','Occlusion');
set(h,'position',[0.273188818560372 0.948945404150761 0.452951397245959 0.0438689226327937],'Orientation','horizontal');
box on
%% Figure S4. The mean participant’s vehicle speed (thicker lines) and the mean lead vehicle speed (thinner lines) in the different braking conditions. Note that in the occlusion condition, the simulator screens blanked for 0.4 s (if 6.5 m/s2) or 2.0 s (if 1.7 m/s2).
figure
subplot(2,2,1);hold on
plot((0:1:1080)/60,B.Sum_V_a1d1(1:1081),'color',[0 0 0],'LineWidth',3);
plot((0:1:1080)/60,V.Sum_V_a1d1(1:1081),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:1080)/60,O.Sum_V_a1d1(1:1081),':','color',[0 0 1],'LineWidth',3);
plot((1:2:1080)/60,B.Sum_Vl_a1d1(2:2:1081),'color',[0 0 0],'LineWidth',1);
plot((1:2:1080)/60,V.Sum_Vl_a1d1(2:2:1081),'--','color',[1 0 0],'LineWidth',1);
plot((1:2:1080)/60,O.Sum_Vl_a1d1(2:2:1081),':','color',[0 0 1],'LineWidth',1);
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[0 100])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Speed (km/h)','Fontsize',20)
text(10,90,'1.7 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,2);hold on
plot((0:1:720)/60,B.Sum_V_a2d1(1:721),'color',[0 0 0],'LineWidth',3);
plot((0:1:720)/60,V.Sum_V_a2d1(1:721),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:720)/60,O.Sum_V_a2d1(1:721),':','color',[0 0 1],'LineWidth',3);
plot((1:2:720)/60,B.Sum_Vl_a2d1(2:2:721),'color',[0 0 0],'LineWidth',1);
plot((1:2:720)/60,V.Sum_Vl_a2d1(2:2:721),'--','color',[1 0 0],'LineWidth',1);
plot((1:2:720)/60,O.Sum_Vl_a2d1(2:2:721),':','color',[0 0 1],'LineWidth',1);
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[0 100])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Speed (km/h)','Fontsize',20)
text(10*12/18,90,'6.5 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,3);hold on
plot((0:1:1080)/60,B.Sum_V_a1d2(1:1081),'color',[0 0 0],'LineWidth',3);
plot((0:1:1080)/60,V.Sum_V_a1d2(1:1081),'--','color',[1 0 0],'LineWidth',3);
plot((0:1:1080)/60,O.Sum_V_a1d2(1:1081),':','color',[0 0 1],'LineWidth',3);
plot((1:2:1080)/60,B.Sum_Vl_a1d2(2:2:1081),'color',[0 0 0],'LineWidth',1);
plot((1:2:1080)/60,V.Sum_Vl_a1d2(2:2:1081),'--','color',[1 0 0],'LineWidth',1);
plot((1:2:1080)/60,O.Sum_Vl_a1d2(2:2:1081),':','color',[0 0 1],'LineWidth',1);
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[0 100])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Speed (km/h)','Fontsize',20)
text(10,90,'1.7 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,4);hold on
plot((1:2:720)/60,B.Sum_V_a2d2(2:2:721),'color',[0 0 0],'LineWidth',3);
plot((1:2:720)/60,V.Sum_V_a2d2(2:2:721),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:720)/60,O.Sum_V_a2d2(2:2:721),':','color',[0 0 1],'LineWidth',3);
plot((1:2:720)/60,B.Sum_Vl_a2d2(2:2:721),'color',[0 0 0],'LineWidth',1);
plot((1:2:720)/60,V.Sum_Vl_a2d2(2:2:721),'--','color',[1 0 0],'LineWidth',1);
plot((1:2:720)/60,O.Sum_Vl_a2d2(2:2:721),':','color',[0 0 1],'LineWidth',1);
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Speed (km/h)','Fontsize',20)
text(10*12/18,90,'6.5 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[0 100])
h=findobj('FontName','Helvetica');
set(h,'FontSize',20,'Fontname','Arial')
h=legend('Brake lights','No brake lights','Occlusion');
set(h,'position',[0.273188818560372 0.948945404150761 0.452951397245959 0.0438689226327937],'Orientation','horizontal');
box on
%% Figure S5. The mean bumper-to-bumper distance in the different braking conditions. Note that in the occlusion condition, the simulator screens blanked for 0.4 s (if 6.5 m/s2) or 2.0 s (if 1.7 m/s2).
figure
subplot(2,2,1);hold on
plot((1:2:1080)/60,B.Sum_D_a1d1(2:2:1081),'color',[0 0 0],'LineWidth',3);
plot((1:2:1080)/60,V.Sum_D_a1d1(2:2:1081),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:1080)/60,O.Sum_D_a1d1(2:2:1081),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[-2 46])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Following distance (m)','Fontsize',20)
text(10,5,'1.7 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,2);hold on
plot((1:2:720)/60,B.Sum_D_a2d1(2:2:721),'color',[0 0 0],'LineWidth',3);
plot((1:2:720)/60,V.Sum_D_a2d1(2:2:721),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:720)/60,O.Sum_D_a2d1(2:2:721),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[-2 46])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Following distance (m)','Fontsize',20)
text(10*12/18,5,'6.5 m/s^2, 13.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,3);hold on
plot((1:2:1080)/60,B.Sum_D_a1d2(2:2:1081),'color',[0 0 0],'LineWidth',3);
plot((1:2:1080)/60,V.Sum_D_a1d2(2:2:1081),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:1080)/60,O.Sum_D_a1d2(2:2:1081),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
set(gca,'xtick',0:2:25)
set(gca,'xlim',[0 18])
set(gca,'ylim',[-2 46])
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Following distance (m)','Fontsize',20)
text(10,5,'1.7 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
box on

subplot(2,2,4);hold on
plot((1:2:720)/60,B.Sum_D_a2d2(2:2:721),'color',[0 0 0],'LineWidth',3);
plot((1:2:720)/60,V.Sum_D_a2d2(2:2:721),'--','color',[1 0 0],'LineWidth',3);
plot((1:2:720)/60,O.Sum_D_a2d2(2:2:721),':','color',[0 0 1],'LineWidth',3);
plot([0 100],[0 0],'k--')
xlabel('Time after lead vehicle brake onset (s)','Fontsize',20)
ylabel('Following distance (m)','Fontsize',20)
text(10*12/18,5,'6.5 m/s^2, 33.4 m','fontsize',20,'FontName','Helvetica')
set(gca,'xtick',0:1:25)
set(gca,'xlim',[0 12])
set(gca,'ylim',[-2 46])
h=findobj('FontName','Helvetica');
set(h,'FontSize',20,'Fontname','Arial')
h=legend('Brake lights','No brake lights','Occlusion');
set(h,'position',[0.273188818560372 0.948945404150761 0.452951397245959 0.0438689226327937],'Orientation','horizontal');
box on
%% Figure 4. Scatter plot of brake response time and minimum following distance. Minimum following distances below the horizontal line were defined as collisions. Vertical dashed lines are drawn for the occlusion durations (0.4 s and 2.0 s, respectively).
[XB,XV,XO]=deal(NaN(4,48,2)); % 4 deceleration conditions x 48 trials x 2 measures
figure
subplot(1,3,1)
for i=1:4 % conditions
    XB(i,:,:)=[reshape(squeeze(B.tRT(i,:,:)),48,1)/60 reshape(squeeze(B.Dmin(i,:,:)),48,1)];
    if i==1
        plot(XB(i,:,1),XB(i,:,2),'mo','markerfacecolor','m','markersize',16);hold on
    elseif i==2
        plot(XB(i,:,1),XB(i,:,2),'ko','markerfacecolor','k','markersize',16)
    elseif i==3
        plot(XB(i,:,1),XB(i,:,2),'go','markerfacecolor','g','markersize',16)
    elseif i==4
        plot(XB(i,:,1),XB(i,:,2),'o','markerfacecolor',[255 165 0]/255,'markeredgecolor',[255 165 0]/255,'markersize',16)
    end
    plot([-100 100],[0 0],'r:','Linewidth',3)
    set(gca,'xlim',[0 5],'ylim',[-5 35],'pos',[0.05 0.12 0.28 0.75])
    xlabel('Brake response time (s)')
    ylabel('Minimum following distance (m)')
    title('Brake lights')
end

subplot(1,3,2)
for i=1:4
    XV(i,:,:)=[reshape(squeeze(V.tRT(i,:,:)),48,1)/60 reshape(squeeze(V.Dmin(i,:,:)),48,1)];
    if i==1
        plot(XV(i,:,1),XV(i,:,2),'mo','markerfacecolor','m','markersize',16);hold on
    elseif i==2
        plot(XV(i,:,1),XV(i,:,2),'ko','markerfacecolor','k','markersize',16)
    elseif i==3
        plot(XV(i,:,1),XV(i,:,2),'go','markerfacecolor','g','markersize',16)
    elseif i==4
        plot(XV(i,:,1),XV(i,:,2),'o','markerfacecolor',[255 165 0]/255,'markeredgecolor',[255 165 0]/255,'markersize',16)
    end
end
legend('1.7 m/s^2, 13.4 m','6.5 m/s^2, 13.4 m','1.7 m/s^2, 33.4 m','6.5 m/s^2, 33.4 m','autoupdate','off','orientation','horizontal','location','northoutside')
plot([-100 100],[0 0],'r:','Linewidth',3)
set(gca,'xlim',[0 5],'ylim',[-5 35],'pos',[0.38 0.12 0.28 0.75])
xlabel('Brake response time (s)')
title('No brake lights')

subplot(1,3,3)
for i=1:4
    XO(i,:,:)=[reshape(squeeze(O.tRT(i,:,:)),48,1)/60 reshape(squeeze(O.Dmin(i,:,:)),48,1)];
    if i==1
        plot(XO(i,:,1),XO(i,:,2),'mo','markerfacecolor','m','markersize',16);hold on
    elseif i==2
        plot(XO(i,:,1),XO(i,:,2),'ko','markerfacecolor','k','markersize',16)
    elseif i==3
        plot(XO(i,:,1),XO(i,:,2),'go','markerfacecolor','g','markersize',16)
    elseif i==4
        plot(XO(i,:,1),XO(i,:,2),'o','markerfacecolor',[255 165 0]/255,'markeredgecolor',[255 165 0]/255,'markersize',16)
    end
    plot([0.4 0.4],[-100 100],'k:','Linewidth',3)
    plot([2 2],[-100 100],'k:','Linewidth',3)
    plot([-100 100],[0 0],'r:','Linewidth',3)
    
    set(gca,'xlim',[0 5],'ylim',[-5 35],'pos',[0.71 0.12 0.28 0.75])
    xlabel('Brake response time (s)')
    title('Occlusion')
end
h=findobj('FontName','Helvetica'); set(h,'FontSize',24,'Fontname','Arial')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01])
%% Figure S6. Top: Brake pedal position in the 33.4 m, 1.7 m/s2 condition
% a1d1 = 1.7 m/s^2, 13.4 m
% a2d1 = 6.5 m/s^2, 13.4 m
% a1d2 = 1.7 m/s^2, 33.4 m
% a2d2 = 6.5 m/s^2, 33.4 m
figure;hold on
counter=0;
for i=1:12
    for i2=1:4
        counter=counter+1;
        subplot(3,1,1)
        title('Brake lights')
        plot((1:2:1080)/60,squeeze(B.Ind_F_a1d2(i,i2,2:2:1081)),'k','linewidth',3);hold on
        grid on
        set(gca,'xlim',[0 6])
        if counter==48
            title('Brake lights')
            set(gca,'xlim',[0 6],'pos',[0.07 0.755 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
        end
        
        subplot(3,1,2)
        title('No brake lights')
        plot((1:2:1080)/60,squeeze(V.Ind_F_a1d2(i,i2,2:2:1081)),'r','linewidth',3);hold on
        if counter==48
            set(gca,'xlim',[0 6],'pos',[0.07 0.435 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
        
        subplot(3,1,3)
        plot((1:2:1080)/60,squeeze(O.Ind_F_a1d2(i,i2,2:2:1081)),'b','linewidth',3);hold on
        if counter==48
            title('Occlusion')
            set(gca,'xlim',[0 6],'pos',[0.07 0.115 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
    end
end

xlabel('Time (s)')
ylabel('Brake (%)')
h=findobj('FontName','Helvetica'); set(h,'FontSize',24,'Fontname','Arial')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01])
set(gcf,'pos',[680 197 847 781])
%% Figure S6. Middle: Brake pedal position in the 33.4 m, 6.5 m/s2 condition
% a1d1 = 1.7 m/s^2, 13.4 m
% a2d1 = 6.5 m/s^2, 13.4 m
% a1d2 = 1.7 m/s^2, 33.4 m
% a2d2 = 6.5 m/s^2, 33.4 m
figure;hold on
counter=0;
for i=1:12
    for i2=1:4
        counter=counter+1;
        subplot(3,1,1)
        title('Brake lights')
        plot((1:2:1080)/60,squeeze(B.Ind_F_a2d2(i,i2,2:2:1081)),'k','linewidth',3);hold on
        grid on
        set(gca,'xlim',[0 6])
        if counter==48
            title('Brake lights')
            set(gca,'xlim',[0 6],'pos',[0.07 0.755 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
        end
        
        subplot(3,1,2)
        title('No brake lights')
        plot((1:2:1080)/60,squeeze(V.Ind_F_a2d2(i,i2,2:2:1081)),'r','linewidth',3);hold on
        if counter==48
            set(gca,'xlim',[0 6],'pos',[0.07 0.435 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
        
        subplot(3,1,3)
        plot((1:2:1080)/60,squeeze(O.Ind_F_a2d2(i,i2,2:2:1081)),'b','linewidth',3);hold on
        if counter==48
            title('Occlusion')
            set(gca,'xlim',[0 6],'pos',[0.07 0.115 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
    end
end

xlabel('Time (s)')
ylabel('Brake (%)')
h=findobj('FontName','Helvetica'); set(h,'FontSize',24,'Fontname','Arial')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01])
set(gcf,'pos',[680 197 847 781])
%% Figure S6. Bottom: Brake pedal position in the 13.4 m, 6.5 m/s2 condition
% a1d1 = 1.7 m/s^2, 13.4 m
% a2d1 = 6.5 m/s^2, 13.4 m
% a1d2 = 1.7 m/s^2, 33.4 m
% a2d2 = 6.5 m/s^2, 33.4 m
figure;hold on
counter=0;
for i=1:12
    for i2=1:4
        counter=counter+1;
        subplot(3,1,1)
        title('Brake lights')
        plot((1:2:1080)/60,squeeze(B.Ind_F_a2d1(i,i2,2:2:1081)),'k','linewidth',3);hold on
        grid on
        set(gca,'xlim',[0 6])
        if counter==48
            title('Brake lights')
            set(gca,'xlim',[0 6],'pos',[0.07 0.755 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
        end
        
        subplot(3,1,2)
        title('No brake lights')
        plot((1:2:1080)/60,squeeze(V.Ind_F_a2d1(i,i2,2:2:1081)),'r','linewidth',3);hold on
        if counter==48
            set(gca,'xlim',[0 6],'pos',[0.07 0.435 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
        
        subplot(3,1,3)
        plot((1:2:1080)/60,squeeze(O.Ind_F_a2d1(i,i2,2:2:1081)),'b','linewidth',3);hold on
        if counter==48
            title('Occlusion')
            set(gca,'xlim',[0 6],'pos',[0.07 0.115 0.9 0.2],'ylim',[0 100])
            ylabel('Brake (%)')
            grid on
        end
    end
end

xlabel('Time (s)')
ylabel('Brake (%)')
h=findobj('FontName','Helvetica'); set(h,'FontSize',24,'Fontname','Arial')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01])
set(gcf,'pos',[680 197 847 781])
%% Stats
disp('Number of trials, number of trials with collisions, and percentage (most urgent condition)')
disp('Occlusion')
disp([sum(sum(XO(2,:,2)>-100)) sum(sum(XO(2,:,2)<0)) round(100*sum(sum(XO(2,:,2)<0))/sum(sum(XO(2,:,2)>-100)))])
disp('Brake lights')
disp([sum(sum(XB(2,:,2)>-100)) sum(sum(XB(2,:,2)<0)) round(100*sum(sum(XB(2,:,2)<0))/sum(sum(XB(2,:,2)>-100)))]) 
disp('No brake lights')
disp([sum(sum(XV(2,:,2)>-100)) sum(sum(XV(2,:,2)<0)) round(100*sum(sum(XV(2,:,2)<0))/sum(sum(XV(2,:,2)>-100)))])

disp('Number of trials, and number of trials braking too early in the Occlusion condition')
disp('1.7 m/s^2, 13.4 m')
disp([sum(sum(XO(1,:,1)>-100)) sum(sum(XO(1,:,1)<2))])
disp('1.7 m/s^2, 33.4 m')
disp([sum(sum(XO(3,:,1)>-100)) sum(sum(XO(3,:,1)<2))])
disp('6.5 m/s^2, 13.4 m')
disp([sum(sum(XO(2,:,1)>-100)) sum(sum(XO(2,:,1)<.4))])
disp('6.5 m/s^2, 33.4 m')
disp([sum(sum(XO(4,:,1)>-100)) sum(sum(XO(4,:,1)<.4))])
